<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $analisiComponente = calcoloStatoComponente($impostazioni, $geecomDb);
    
    $totaleOrdini    = $geecomDb->contaRigheTabella("geecEc_ordini");
    $queryOrdiniOggi = "SELECT COUNT(*) FROM `geecEc_ordini` WHERE dataOrdine>'".date("Y-m-d")."'";		
    $result          = $geecomDb->eseguiQueryLettura($queryOrdiniOggi);
    $arrayRisultato  = $result->fetch_array(MYSQLI_NUM);
    $ordiniOggi      = $arrayRisultato[0];
?>
    <div class="row d-flex align-items-center mt-3">
        <div class="col-xl-3 mb-3 mb-xl-0">
            <div class="alert alert border-<?php echo $analisiComponente["classeBoxUtilizzo"]; ?> col-12 text-center mb-0 seo text-<?php echo $analisiComponente["classeBoxUtilizzo"]; ?>">
                <h6><i class="<?php echo $analisiComponente["icona"]; ?>"></i> Rapporto visite/conversioni:<strong><?php echo ceil($analisiComponente["rapportoVisiteOrdini"]); ?> %</strong></h6>
                <hr class="my-2">
                <p ><?php confrontoMediaPunteggio(ceil($analisiComponente["rapportoVisiteOrdini"])); ?><i class="fas fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Il rapporto visite / ordini di un ecommerce è in media del 3%"></i></p>
                <?php
                    if(strpos($_SERVER["PHP_SELF"],"home.php")>0) {
                ?>
                        <a class="btn btn-<?php echo $analisiComponente["classeBoxUtilizzo"]; ?> btn-sm leggi-tutto" href="componenti/ecommerce/index.php?status=100">Dettagli</a>
                <?php
                    }
                ?>
            </div>
        </div>
        <div class="col-xl-9">
            <div id="contatori" class="row">
                <div class="col-md-6">
                    <div class="card border-0 p-3 mb-3 mb-md-0 box-shadow-lite shadow">
                        <h5 class="text-primary mb-0 mx-auto"><i class="fas fa-cart-arrow-down mr-2"></i>Ordini</h5>
                        <hr>
                        <div class="row">
                            <div class="col text-center">
                                <strong>Totali</strong><br>
                                <span><?php echo $totaleOrdini; ?></span>
                            </div>
                            <div class="col text-center">
                                <strong>Oggi</strong><br>
                                <span><?php echo $ordiniOggi; ?></span>
                            </div>
                            <div class="col text-center">
                                <?php 
                                
                                ?>
                                <strong>Media giornaliera</strong><br>
                                <span><?php echo(($differenzaGiorni==0) ? $ordiniOggi : number_format($totaleOrdini/$differenzaGiorni,2)) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card border-0 p-3 mb-3 mb-md-0 box-shadow-lite shadow">
                        <h5 class="text-primary mb-0 mx-auto"><i class="fas fa-euro-sign mr-2"></i>Incassi</h5>
                        <hr>
                        <div class="row">
                            <div class="col text-center">
                                <strong>Totali</strong><br>
                                <span><?php echo($geecomDb->sommaValoriColonna("importoTotaleOrdine","geecEc_ordini")); ?></span>
                            </div>
                            <div class="col text-center">
                                <?php 
                                
                                    if($ordiniOggi==0) {
                                        $incassoOggi = array(0);
                                    }
                                    else {
                                        $queryStatistiche = "SELECT SUM(importoTotaleOrdine) FROM geecEc_ordini WHERE dataOrdine >= '".date("Y-m-d")."'";
                                        $risStat = $geecomDb->eseguiQueryLettura($queryStatistiche);
                                        $incassoOggi = $risStat->fetch_array(MYSQLI_NUM);
                                    }
                                ?>
                                <strong>Oggi</strong><br>
                                <span><?php echo $incassoOggi[0]; ?>
                            </div>
                            <div class="col text-center">
                                <strong>Media giornaliera</strong><br>
                                <span><?php echo(($differenzaGiorni==0) ? $incassoOggi[0] : number_format($incassoOggi[0]/$differenzaGiorni,2)) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
    function calcoloStatoComponente($impostazioniAspetto, $geecomDb) {
        $datiStatistiche = $geecomDb->leggiSingolaRiga("geecB_statistiche",1);
        $numeroOrdini    = $geecomDb->contaRigheTabella("geecEc_ordini");
        $numeroVisiteTotali = $geecomDb->sommaValoriColonna("visualizzazioni","geecB_visualizzazioniGiornaliere");
        $rapportoVisiteOrdini = $numeroVisiteTotali * $numeroOrdini / 100;
        
        // prepara l'array per restituire le informazioni
        $risultatoAnalisi = array();
        $risultatoAnalisi["rapportoVisiteOrdini"] = $rapportoVisiteOrdini;
        
        if($rapportoVisiteOrdini>=3) {
            $risultatoAnalisi["classeBoxUtilizzo"] = "success";
            $risultatoAnalisi["classeTestiCss"]    = "success";
            $risultatoAnalisi["icona"] = "fa fa-smile-o";
        }
        else if($rapportoVisiteOrdini<1 && $rapportoVisiteOrdini>3){
            $risultatoAnalisi["classeBoxUtilizzo"] = "warning";
            $risultatoAnalisi["classeTestiCss"]    = "warning";
            $risultatoAnalisi["icona"] = "fa fa-meh-o";
        }
        else {
            $risultatoAnalisi["classeBoxUtilizzo"] = "danger";
            $risultatoAnalisi["classeTestiCss"]    = "danger";
            $risultatoAnalisi["icona"] = "fa fa-frown-o";
        }
        return $risultatoAnalisi;
    }